//O.S : Windows 10
//Scilab Version: 6.0.1
//Caption: Discrete Time Fourier Transform of x[n]= 1 , abs(n)<=N1
clear;
close;
clc;
// DTS Signal
N1 = 2;
n=-N1:N1;
x=ones(1,length(n));
// Discrete-time Fourier Transform
Wmax=2*%pi;
K =4;
k =0:(K/1000):K;
W =k*Wmax/K;
XW =x*exp(-sqrt(-1)*n'*W);
XW_Mag=real(XW);
W=[-mtlb_fliplr(W), W(2:1001)]; // Omega from -Wmax to Wmax
XW_Mag=[mtlb_fliplr(XW_Mag),XW_Mag(2:1001)];
//plot for abs(a)<1
subplot(2,1,1);
xgrid(4,1,7);
xlabel("<-----n----->","fontsize",2,"color", "blue");
ylabel("Amplitude","fontsize",2,"color","blue");
a = gca();
a.y_location ="origin";
a.x_location ="origin";
plot2d3('gnn',n,x);
title("Discrete Time Sequence x[n]","fontsize",2,"color","blue");
subplot(2,1,2);
xgrid(4,1,7);
xlabel("<--------n-------->","fontsize",2,"color", "blue");
ylabel("Amplitude", "fontsize",2, "color", "blue");
//ylabel("Amplitude");
a = gca();
a.y_location ="origin";
a.x_location ="origin";
plot2d(W,XW_Mag);
title("Discrete Time Fourier Transform X(exp(jW))","fontsize",2,"color", "blue")'
